#include "General.h"
#include "ChinookArmorMod.h"
#include "PhysicalGameObj.h"
#include "PowerupGameObj.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "gmgame.h"

ChinookArmorMod::ChinookArmorMod()
{
	RegisterEvent(EVENT_OBJECT_CREATE_HOOK,this);
}

ChinookArmorMod::~ChinookArmorMod()
{
	UnregisterEvent(EVENT_OBJECT_CREATE_HOOK,this);
}

void ChinookArmorMod::OnObjectCreate(void *data,GameObject *obj)
{
	if(obj->As_VehicleGameObj() && !strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Transport") || !strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Transport"))
	{
		Commands->Set_Shield_Type(obj, "CNCVehicleMedium");
	}
}

ChinookArmorMod chinookArmorMod;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &chinookArmorMod;
}
